#!/bin/sh

#########################################################
#            AVSMaker Professional Edition              #
#     Written entirely by Dan Jones (sf@termina.com)    #
#########################################################
#                                                       #
#                                                       #
# This script was created by:                           #
#                                                       #
# PerlCoders Web Specialties PTY.                       #
# http://www.perlcoders.com                             #
#                                                       #
# This script and all included modules, lists or        #
# images, documentation are copyright only to           #
# PerlCoders PTY (http://perlcoders.com) unless         #
# otherwise stated in the module.                       #
#                                                       #
# Purchasers are granted rights to use this script      #
# on any site they own. There is no individual site     #
# license needed per site.                              #
#                                                       #
# Any copying, distribution, modification with          #
# intent to distribute as new code will result          #
# in immediate loss of your rights to use this          #
# program as well as possible legal action.             #
#                                                       #
# This and many other fine scripts are available at     #
# the above website or by emailing the authors at       #
# staff@perlcoders.com or info@perlcoders.com           #
#                                                       #
#########################################################

#########################################################
#                                                       #
#  Installs AVSMaker Professional                       #                                                      #
#  Usage:                                               #
#       ./install.sh                                    #
#                                                       #
#########################################################

MYSQL_USER="root"		# Your MySQL username
MYSQL_HOST="localhost"		# MySQL host to use
MYSQL_PORT="3306"		# Port of MySQL server
MYSQL_DB="avspro"		# Database name
DB_EXISTS="no"			# Set to "yes" if database already exists
TMPPATH="/tmp"			# Set to a temporary, world-writeable path

# MYSQL="/usr/local/bin/mysql"	# Uncomment this line to specify mysql location




# Example data GREATLY recommended!
INCLUDE_EXAMPLES="yes"

PERL=/usr/bin/perl
CRONTAB=/usr/bin/crontab


#------------------------! do not edit below this line !----------------------


if [ ! "$MYSQL" ]; then
	MYSQL=`which mysql | grep -v no\ mysql`;
	if [ "`which whereis | grep -v no\ whereis`" -a "`which awk | grep -v no\ awk`" -a ! "$MYSQL" ]; then
		MYSQL="`whereis mysql | awk '{print $2}'`"
	fi
fi

die () {
	echo $1
	exit 1
}

echo AVSMaker Professional Installation
echo -------------------------------------

if [ ! -d $TMPPATH -o ! -w $TMPPATH ]; then die "$TMPPATH is not writeable or not a directory, please set in install.sh"; fi
if [ ! -x $PERL ]; then PERL="`which perl`"; fi
if [ ! -x $PERL ]; then die "Could not find perl binary, please set in install.sh"; fi
if [ ! -x $CRONTAB ]; then CRONTAB="`which crontab`"; fi
if [ ! -x $CRONTAB ]; then die "Could not find crontab binary, please set in install.sh"; fi
if [ ! "$MYSQL" -o ! -x "$MYSQL" ]; then
	die "Could not find MySQL, please set in install.sh"
fi

echo "MySQL information:" 
echo " * username - $MYSQL_USER"
echo " * host     - $MYSQL_HOST"
echo " * port     - $MYSQL_PORT"
echo " * database - $MYSQL_DB"
echo " * database already exists? $DB_EXISTS"
echo Does this all sound right? [y/n]
read OK
if [ "$OK" != "y" ]; then
	die "Installation exiting..."
fi

if [ ! "`$CRONTAB -l 2>/dev/null | grep scheduler\.pl`" ]; then
	$CRONTAB -l >/tmp/crontab.ap 2>/dev/null
	echo "0 * * * * cd $PWD && ./scheduler.pl" >> /tmp/crontab.ap
	$CRONTAB /tmp/crontab.ap || die "Could not add to crontab"
	rm -f /tmp/crontab.ap
fi

$PERL -i -pe "s!%perl%!$PERL!" *.pl *.cgi || die "Could not set perl path"
$PERL setperms.pl || die "Could not execute setperms.pl, check perl is installed correctly"
echo Permissions set successfully

echo Enter MySQL password:
read MYSQL_PASS

if [ "$DB_EXISTS" = "no" ]; then
$MYSQL -u $MYSQL_USER -p$MYSQL_PASS -h $MYSQL_HOST -P $MYSQL_PORT <<EOF \
	|| die "Could not create MySQL database, please check your information is correct in install.sh. Set DB_EXISTS to 'yes' if you wish to add to an existing database. If you want to delete the current $MYSQL_DB database, do:  mysqladmin -u $MYSQL_USER -p drop $MYSQL_DB"
create database $MYSQL_DB;
EOF
fi

$MYSQL -u $MYSQL_USER -p$MYSQL_PASS -h $MYSQL_HOST -P $MYSQL_PORT $MYSQL_DB <<EOF \
	|| die "Could not create standard MySQL tables"
# Personal information / configuration table
create	table	ap_data (
	chname		varchar(20)	not null,
	surname		varchar(20)	not null,
	email		varchar(45)	not null,
	pcpass		varchar(15)	not null,
	
	addr1		varchar(25)	not null,
	addr2		varchar(25),
	city		varchar(20)	not null,
	state		varchar(20),
	zip		varchar(10),
	country		varchar(15)	not null,
	phone		varchar(15),
	fax		varchar(15),	
	defpass		varchar(25)	not null,

	imagepath	varchar(70)	not null,
	cjpeg		varchar(40)	not null,
	djpeg		varchar(40)	not null,
	pnmscale	varchar(40)	not null,

	lastupdateid    int(4),	
	remsitenames	tinyint(1)	default 0,
	remheaders	tinyint(1)	default 0,
	remdescrs	tinyint(1)	default 0,
	remparagraphs	tinyint(1)	default 0,
	uselogogen	tinyint(1)	default 0,
	usehtaccess	tinyint(1)	default 1,
	usesymlinks	tinyint(1)	default 1,
	usefreehosts	tinyint(1)	default 1,
	quietsched	tinyint(1)	default 1,
	numkeywords	int(2)		default 3,
	
	defcols		int(2)		default 4,
	defrows		int(2)		default 3,
	defthumbx	int(3)		default 128,
	defthumby	int(3)		default 96,
	
	numlinks	int(4)		default 20,
	lsgtime		int(3)		default 14,
	searchurl	varchar(70)	not null,
	searchscheme	varchar(20)
);

# Users
create	table	ap_users (
	uid		int(3)		auto_increment	not null,
	username	varchar(10)	not null,
	password	varchar(30)	not null,
	lasttime	datetime,
	lastip		varchar(16),
	
	primary key	(uid)
);

# Actions and permissions required
create	table	ap_actions (
	action		char(20)	not null,
	permlevel	int(1)		not null,
	
	primary key	(action)
);

insert into ap_actions values
	("register",		0),
	("login",		0),
	("index",		1),
	("quickgen",		1),
	("sitegen",		1),
	("createsite",		1),
	("progress",		1),
	("deltestsites",	1),
	("refreshimgqueue",	1),
	("selectscheme",	1),
	("editschemes",		1),
	("delscheme",		1),
	("writescheme",		1),
	("editptags",		1),
	("writeptags",		1),
	("editlayouts",		1),
	("editpagetypes",	1),
	("writepagetypes",	1),
	("editstructures",	1),
	("dellayout",		1),
	("writestructure",	1),
	("selecttemplatetype",	1),
	("selecttemplate",	1),
	("othertemplates",	1),
	("edittemplate",	1),
	("deltemplate",		1),
	("writetemplate",	1),
	("edithtmlext",		1),
	("writehtmlext",	1),
	("imagetypes",		1),
	("writeimagetypes",	1),
	("imguploadloc",	1),
	("editcats",		1),
	("writecats",		1),
	("editnames",		1),
	("writenames",		1),
	("editheaders",		1),
	("writeheaders",	1),
	("editdescr",		1),
	("writedescrs",		1),
	("editparagraphs",	1),
	("writeparagraphs",	1),
	("editkeywords",	1),
	("writekeywords",	1),
	("editdomainlist",	1),
	("writedomainlist",	1),
	("editdirlist",		1),
	("writedirlist",	1),
	("writedirexts",	1),
	("writememareas",	1),
	("editavsdirs",		1),
	("writeavsdirs",	1),
	("edithtaccess",	1),
	("writehtaccess",	1),
	("quicksponsors",	1),
	("editsponsors",	1),
	("addsponsors",		1),
	("delsponsor",		1),
	("writesponsors",	1),
	("edittextlinks",	1),
	("editcattextlinks",	1),
	("editspontextlinks",	1),
	("writetextlinks",	1),
	("editsubs",		1),
	("writesubs",		1),
	("editaccounts",	1),
	("writeaccounts",	1),
	("assigncatselect",	1),
	("assigncats",		1),
	("writecatassigns",	1),
	("editfreehosts",	1),
	("writefreehosts",	1),
	("viewsites",		1),
	("siteinfo",		1),
	("editfile",		1),
	("savefile",		1),
	("editlinklists",	1),

	("editusers",		2),
	("adduser",		2),
	("deluser",		2),
	("editperms",		2),
	("writeperms",		2),
	("gensetup",		1),
	("writegensetup",	1),
	("edittimers",		1),
	("savetimers",		1),
	("listpacks",		1),
	("addpack",		1),
	("doaddpack",		0),
	("updatescript",	1),

	("support",		0),
	("sendmail",		0),	
	("doc",			0),
	("passwd",		1),
	("logout",		1);
	

# Site data tables
create 	table	ap_cats (
	name		varchar(10)	not null
);

create	table	ap_sitenames (
	name		varchar(50)	not null,
	cat		varchar(10)
);

create	table	ap_headers (
	text		varchar(80)	not null,
	cat		varchar(10)
);
create	table	ap_descr (
	text		varchar(120)	not null,
	cats		varchar(50)
);
create	table	ap_paragraphs (
	text		varchar(200)	not null,
	cats		varchar(50)
);
create	table	ap_keywords (
	word		varchar(25)	not null,
	cats		varchar(50)
);


create	table	ap_lsnames (
	name		varchar(30)	not null,
	cats		varchar(50)
);

create	table	ap_imagetypes (
	name		char(10)	not null
);

insert	into ap_imagetypes values
	("large"),
	("small");

create	table	ap_images (
	cat		char(10)	not null,
	type		char(10)	not null,
	image		varchar(30)	not null,
	queued		tinyint(1)	default 1
);

create	table	ap_imagesets (
	cat		char(10)	not null,
	setname		varchar(30)	not null,
 	queued		tinyint(1)	default 1
);


# Layout of each site; pagetype (directory) for each position must be given
create	table	ap_pagetypes (
	name		varchar(20)	not null,
	
	primary key (name)
);

create	table	ap_layouts (
	name		varchar(20)	not null,
	cats		varchar(50),
	avss		varchar(20),
	free		tinyint(1)	default 0,
	scheme		varchar(20),
	
	tour1		varchar(20)	not null,
	tour2		varchar(20),
	tour3		varchar(20),
	tour4		varchar(20),
	tour5		varchar(20),
	tour6		varchar(20),

	cont1		varchar(20)	not null,
	cont2		varchar(20),
	cont3		varchar(20),
	cont4		varchar(20),
	cont5		varchar(20),
	cont6		varchar(20),
	cont7		varchar(20),
	cont8		varchar(20),
	cont9		varchar(20),
	cont10		varchar(20),
	cont11		varchar(20),
	cont12		varchar(20),
	cont13		varchar(20),
	cont14		varchar(20),
	cont15		varchar(20),
	
	primary key	(name)
);



# Physical layout; domains, site directory prefixes, members' area dir names
create	table	ap_domains (
	domain		varchar(40)	not null,
	cats		varchar(50),
	dir		varchar(70)	not null
#	subdir		varchar(10),
);

create	table	ap_dirs (
	dir		varchar(20)	not null,
	cats		varchar(50)
);
create	table	ap_direxts (
	ext		varchar(12)	not null
);
create	table	ap_memarea (
	dir		varchar(40)	not null
);
create	table	ap_htmlext (
	ext		varchar(6)	not null
);



# Sponsorship/banner tables
create	table	ap_sponsors (
	id		varchar(12)	not null,
	name		varchar(30)	not null,
	cats		varchar(50),
	linkcode	varchar(200)	not null,
	
	primary key	(id)
);
create	table	ap_textlinks (
	text		varchar(240)	not null,
	sponsor		varchar(12),
	cat		varchar(10)
);




# HTTP UserAgents; alteration not recommended
create	table	ap_useragents (
	ua		varchar(80)	not null
);
insert	into ap_useragents values
	("Lynx/2.8rel.2 libwww-FM/2.14"),
	("Mozilla/2.0 (compatible; MSIE 3.0; Windows 95)"),
	("Mozilla/4.0 (compatible; MSIE 4.01; Windows 95)"),
	("Mozilla/4.0 (compatible; MSIE 4.01; Windows 98)"),
	("Mozilla/4.0 (compatible; MSIE 4.01; Windows 98)"),
	("Mozilla/4.0 (compatible; MSIE 5.01; Windows 98)"),
	("Mozilla/4.0 (compatible; MSIE 5.0; Windows 95)"),
	("Mozilla/4.0 (compatible; MSIE 5.0; Windows 95; DigExt)"),
	("Mozilla/4.0 (compatible; MSIE 5.0; Windows 98)"),
	("Mozilla/4.0 (compatible; MSIE 5.0; Windows 98)"),
	("Mozilla/4.0 (compatible; MSIE 5.0; Windows 98)"),
	("Mozilla/4.0 (compatible; MSIE 5.0; Windows 98; DIL0001017)"),
	("Mozilla/4.0 (compatible; MSIE 5.0; Windows 98; DigExt)"),
	("Mozilla/4.0 (compatible; MSIE 5.0; Windows 98; DigExt)"),
	("Mozilla/4.0 (compatible; MSIE 5.0; Windows 98; MS ITG IE5 internal)"),
	("Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)"),
	("Mozilla/4.04 [en] (Win95; I ;Nav)"),
	("Mozilla/4.06 [en] (Win98; I)"),
	("Mozilla/4.08 [en] (Win95; U ;Nav)"),
	("Mozilla/4.08 [en] (Win98; U ;Nav)"),
	("Mozilla/4.51 [en] (Win98; I)"),
	("Mozilla/4.51 [en] (X11; I; Linux 2.2.14 i686)"),
	("Mozilla/4.6 [en] (Win98; I)"),
	("Mozilla/4.61 [en] (Win95; I)"),
	("Mozilla/4.7 [en] (Win98; I)"),
	("Mozilla/4.7 [en] (X11; I; Linux 2.2.13 i586)"),
	("Mozilla/4.72 [en]C-compaq  (Win98; U)");




# HTML Appearance tables
# Table of HTML schemes ("light", "dungeon", "teen", or whatever..)
create	table	ap_schemes (
	name		varchar(20)	not null,
	cats		varchar(50),
	primary key (name)
);
# Body tags ('bgcolor=#ffffff text=#000000')
create	table	ap_bodytags (
	tag		varchar(100)	not null,
	scheme		varchar(20)	not null
);
# Table tags ('cellpadding=8 cellspacing=5 border=1')
create	table	ap_tabletags (
	tag		varchar(100)	not null,
	scheme		varchar(20)	not null
);
# <td> tags - same as body
create	table	ap_tdtags (
	tag		varchar(100)	not null,
	scheme		varchar(20)	not null
);
# Font tags ('face="Verdana, Arial, sans-serif" style="font-size: 11"')
create	table	ap_fonttags (
	tag		varchar(100)	not null,
	scheme		varchar(20)	not null
);
# Logo gen colours
create	table	ap_logogen (
	fg		char(6),
	bg		char(6),
	scheme		varchar(20)	not null
);


# Javascript code
create	table	ap_js (
	tag		text		not null,
	scheme		varchar(20)	not null
);
# CSS code
create	table	ap_css (
	tag		text		not null,
	scheme		varchar(20)	not null
);

# New custtag HTML tags
create	table	ap_custtag1 (
	tag		text		not null,
	scheme		varchar(20)	not null
);
create	table	ap_custtag2 (
	tag		text		not null,
	scheme		varchar(20)	not null
);
create	table	ap_custtag3 (
	tag		text		not null,
	scheme		varchar(20)	not null
);
                                




# Existing AVSMakerPro-created sites
create	table	ap_sites (
	id		int(6) zerofill		not null auto_increment,
	ctime		datetime		not null,
	sitename	varchar(50)		not null,
	cat		varchar(10)		not null,
	descr		varchar(100)		not null,
	keywords	varchar(100)		not null,
	domain		varchar(40)		not null,
	dir		varchar(25)		not null,
	memarea		varchar(20)		not null,
	htmlext		varchar(6)		not null,
	numavss		int(1)			not null,
	
	avs1_id		char(3),
	avs1_acc	int(3),
	avs1_dir	varchar(12),
	avs1_siteid	varchar(15),

	avs2_id		char(3),
	avs2_acc	int(3),
	avs2_dir	varchar(12),
	avs2_siteid	varchar(15),

	avs3_id		char(3),
	avs3_acc	int(3),
	avs3_dir	varchar(12),
	avs3_siteid	varchar(15),

	avs4_id		char(3),
	avs4_acc	int(3),
	avs4_dir	varchar(12),
	avs4_siteid	varchar(15),

	avs5_id		char(3),
	avs5_acc	int(3),
	avs5_dir	varchar(12),
	avs5_siteid	varchar(15),

	avs6_id		char(3),
	avs6_acc	int(3),
	avs6_dir	varchar(12),
	avs6_siteid	varchar(15),

	avs7_id		char(3),
	avs7_acc	int(3),
	avs7_dir	varchar(12),
	avs7_siteid	varchar(15),

	avs8_id		char(3),
	avs8_acc	int(3),
	avs8_dir	varchar(12),
	avs8_siteid	varchar(15),
	
	primary key 	(id)
);

create	table	ap_testsites (
	path		varchar(70)	not null
);

# Index of linksites, main site id 1
create	table	ap_linksites (
	id		int(6) zerofill not null auto_increment,
	name		varchar(40)	not null,
	path		varchar(70)	not null,
	url		varchar(70)	not null,
	cat		char(10),
	mod		char(3),

	primary key (id)
);


# AVS tables
create	table	ap_avs (
	id		char(3)		not null,
	name		char(16)	not null,
	dir		varchar(12)	not null,
	dlimit		int(3)		not null,
	catspersub	int(1)		not null,
	reqinit		tinyint(1)	not null	default 0,
	enabled		tinyint(1)	not null	default 1,

	primary key 	(id)
);

insert	into ap_avs 	values
	("cyb", "CyberAge",	"cyb", 25, 3, 1, 1),
	("vip", "VIP-ID",	"vip", 10, 2, 1, 1),
	("ntv", "NetVerifier",	"ntv", 15, 1, 1, 0),
	("adc", "AdultCheck",	"adc", 10, 1, 0, 1),
	("adr", "AdultRide",	"adr", 25, 2, 0, 1),
	("gvr", "GetVerified",	"gvr", 25, 1, 1, 1),
	("ugs", "UGAS",		"ugs", 20, 3, 0, 1),
	("fnp", "FreeNetPass",	"fnp", 20, 3, 0, 0),
	("gmp", "GlobalMalePass", "gmp", 25, 3, 0, 0);

create	table	ap_avs_cats (
	avs		char(3)		not null,
	code		varchar(20)	not null,
	fvalue		varchar(10),
	name		varchar(35)	not null
);

insert	into ap_avs_cats values
	("cyb", "1", "0", "Variety"),
	("cyb", "2", "0", "Women"),
	("cyb", "3", "1", "Lesbian"),
	("cyb", "4", "1", "Gay"),
	("cyb", "5", "0", "Amateur"),
	("cyb", "6", "0", "Bondage"),
	("cyb", "7", "0", "Voyeur"),
	("cyb", "8", "0", "Hardcore"),
	("cyb", "9", "0", "Asian"),
	("cyb", "10", "0", "Celebrity"),
	("cyb", "11", "0", "Ebony"),
	("cyb", "12", "0", "Hot Videos"),
	("cyb", "13", "0", "Young Girls(18+)"),
	("cyb", "14", "1", "Young Boys(18+)"),
	("cyb", "15", "0", "Fetishes"),
	("cyb", "16", "0", "Bizarre"),
	("cyb", "17", "0", "Anal"),
	("cyb", "18", "0", "Lingerie"),
	("cyb", "19", "0", "Bisexual"),
	("cyb", "20", "0", "Breasts"),
	("cyb", "21", "0", "Large Breasts"),
	("cyb", "22", "0", "Models"),
	("cyb", "23", "0", "Erotica"),
	("cyb", "24", "0", "Ethnic"),
	("cyb", "25", "0", "Masturbation"),
	("cyb", "26", "0", "Stories"),
	("cyb", "27", "0", "Softcore"),
	("cyb", "28", "0", "Porn Stars"),
	("cyb", "29", "0", "Body Builders"),
	("cyb", "30", "0", "Oral"),
	("cyb", "31", "0", "Latin"),
	("cyb", "32", "0", "Nudists"),
	("cyb", "33", "0", "Older Women"),
	("cyb", "34", "0", "Close Ups"),
	("cyb", "35", "0", "Blondes"),
	("cyb", "36", "0", "Brunettes"),
	("cyb", "37", "0", "Red Heads"),
	("cyb", "38", "0", "Toys"),
	("cyb", "39", "0", "International"),
	("cyb", "40", "0", "Nice Ass"),
	("cyb", "41", "0", "Swingers"),
	("cyb", "42", "0", "Transgender"),
	("cyb", "43", "0", "Pay Sites"),
	("cyb", "44", "0", "Spanking"),
	("cyb", "45", "0", "Big Women"),
	("cyb", "46", "0", "Hunks"),
	("cyb", "47", "0", "Leather"),
	("cyb", "48", "1", "Daddies"),
	("cyb", "49", "1", "Bears"),
	("cyb", "50", "1", "Older Men"),
	("cyb", "51", "1", "Men"),
	("cyb", "52", "0", "Cartoons"),
	("vip", "1.10", "", "Hardcore"),
	("vip", "1.12", "", "Lesbian"),
	("vip", "1.14", "", "Nudists"),
	("vip", "1.16", "", "Porn Stars"),
	("vip", "1.18", "", "Softcore"),
	("vip", "1.3", "", "Barely Legal"),
	("vip", "1.5", "", "Black"),
	("vip", "1.7", "", "Breasts"),
	("vip", "1.9", "", "Celebrities"),
	("vip", "2.10", "", "Hardcore"),
	("vip", "2.12", "", "Nudists"),
	("vip", "2.14", "", "Porn Stars"),
	("vip", "2.16", "", "Young Studs"),
	("vip", "2.4", "", "Black"),
	("vip", "2.6", "", "Brunettes"),
	("vip", "2.8", "", "Gay Sex"),
	("vip", "3.1", "", "Anime/Cartoons"),
	("vip", "3.11", "", "Spanking"),
	("vip", "3.13", "", "Toys"),
	("vip", "3.15", "", "Water Sports"),
	("vip", "3.3", "", "BDSM"),
	("vip", "3.5", "", "Fem Dom"),
	("vip", "3.7", "", "Fisting"),
	("vip", "3.9", "", "Hidden Camera"),	
	("adc", "28", "", "Amateur/Exhibitionist (Men)"),
	("adc", "35", "", "Asian (Men)"),
	("adc", "34", "", "Black (Men)"),
	("adc", "38", "", "Daddies/Bears (Men)"),
	("adc", "31", "", "Fetish (Men)"),
	("adc", "29", "", "GaySex (Men)"),
	("adc", "27", "", "Hardcore (Men)"),
	("adc", "26", "", "Hunks (Men)"),
	("adc", "70", "", "International (Men)"),
	("adc", "36", "", "Latin (Men)"),
	("adc", "32", "", "Leather/Bondage (Men)"),
	("adc", "30", "", "Models/Celebrities (Men)"),
	("adc", "40", "", "Movies/Video/Audio (Men)"),
	("adc", "69", "", "OlderMen (Men)"),
	("adc", "39", "", "Photography (Men)"),
	("adc", "41", "", "PornStars (Men)"),
	("adc", "25", "", "Softcore (Men)"),
	("adc", "33", "", "Variety (Men)"),
	("adc", "37", "", "Young Men"),
	("adc", "42", "", "AdultStore"),
	("adc", "45", "", "Anime/Hentai/Erotic"),
	("adc", "47", "", "Bizarre"),
	("adc", "48", "", "BodyBuilders"),
	("adc", "49", "", "Cartoons/Humor/Jokes"),
	("adc", "71", "", "Chat"),
	("adc", "44", "", "Non-Sexual"),
	("adc", "43", "", "PaySite"),
	("adc", "50", "", "Stories"),
	("adc", "46", "", "Swingers"),
	("adc", "51", "", "Transgender"),
	("adc", "6", "", "Amateur/Exhibitionist (Women)"),
	("adc", "67", "", "Anal (Women)"),
	("adc", "13", "", "Asian (Women)"),
	("adc", "24", "", "Babes (Women)"),
	("adc", "53", "", "BBW (Women)"),
	("adc", "11", "", "BDSM (Women)"),
	("adc", "15", "", "Black (Women)"),
	("adc", "61", "", "Blondes (Women)"),
	("adc", "56", "", "Breasts (Women)"),
	("adc", "62", "", "Brunettes (Women)"),
	("adc", "60", "", "CloseUps (Women)"),
	("adc", "59", "", "FemDom (Women)"),
	("adc", "10", "", "Fetish (Women)"),
	("adc", "65", "", "Fisting (Women)"),
	("adc", "54", "", "Foot/Stockings (Women)"),
	("adc", "4", "", "Hardcore (Women)"),
	("adc", "58", "", "Indian (Women)"),
	("adc", "68", "", "International (Women)"),
	("adc", "16", "", "Latin (Women)"),
	("adc", "8", "", "Lesbians (Women)"),
	("adc", "17", "", "Lingerie/SwimWear (Women)"),
	("adc", "66", "", "Masturbation (Women)"),
	("adc", "9", "", "Models/Celebrities (Women)"),
	("adc", "57", "", "Money Shot"),
	("adc", "18", "", "Movies/Video/Audio (Women)"),
	("adc", "21", "", "Nudists (Women)"),
	("adc", "23", "", "OlderWomen (Women)"),
	("adc", "7", "", "Oral (Women)"),
	("adc", "20", "", "Photography (Women)"),
	("adc", "19", "", "Porn Stars"),
	("adc", "63", "", "Redheads (Women)"),
	("adc", "5", "", "Softcore (Women)"),
	("adc", "55", "", "Spanking (Women)"),
	("adc", "64", "", "Toys/Objects (Women)"),
	("adc", "12", "", "Variety (Women)"),
	("adc", "22", "", "Voyeur (Women)"),
	("adc", "52", "", "Watersports (Women)"),
	("adc", "14", "", "Young Women"),
	("adr", "None", "", "None"),
	("adr", "Women", "", "Women"),
	("adr", "Men", "", "Men"),
	("adr", "Voyeur", "", "Voyeur"),
	("adr", "Fetish", "", "Fetish"),
	("adr", "Amateur", "", "Amateur"),
	("adr", "18", "", "18"),
	("adr", "Hardcore", "", "Hardcore"),
	("adr", "Celebs", "", "Celebs"),
	("adr", "Lesbian", "", "Lesbian"),
	("adr", "Asian", "", "Asian"),
	("adr", "Ebony", "", "Ebony"),
	("gvr", "Amateurs", "", "Amateurs"),
	("gvr", "Anal", "", "Anal"),
	("gvr", "Asian", "", "Asian"),
	("gvr", "Big", "", "Big"),
	("gvr", "Bisexual", "", "Bisexual"),
	("gvr", "Bizarre", "", "Bizarre"),
	("gvr", "Blondes", "", "Blondes"),
	("gvr", "Bondage", "", "Bondage"),
	("gvr", "Breasts", "", "Breasts"),
	("gvr", "Brunettes", "", "Brunettes"),
	("gvr", "Ebony", "", "Ebony"),
	("gvr", "Erotica", "", "Erotica"),
	("gvr", "Fetishes", "", "Fetishes"),
	("gvr", "Gay", "", "Gay"),
	("gvr", "Hardcore", "", "Hardcore"),
	("gvr", "HotVideos", "", "HotVideos"),
	("gvr", "Hunks", "", "Hunks"),
	("gvr", "European", "", "European"),
	("gvr", "LargeBreasts", "", "LargeBreasts"),
	("gvr", "Latin", "", "Latin"),
	("gvr", "Leather", "", "Leather"),
	("gvr", "Lesbian", "", "Lesbian"),
	("gvr", "Lingerie", "", "Lingerie"),
	("gvr", "Masturbation", "", "Masturbation"),
	("gvr", "Men", "", "Men"),
	("gvr", "Nudists", "", "Nudists"),
	("gvr", "OlderMen", "", "OlderMen"),
	("gvr", "OlderWomen", "", "OlderWomen"),
	("gvr", "Oral", "", "Oral"),
	("gvr", "PaySites", "", "PaySites"),
	("gvr", "PornStars", "", "PornStars"),
	("gvr", "RedHeads", "", "RedHeads"),
	("gvr", "SchoolGirls", "", "SchoolGirls"),
	("gvr", "Softcore", "", "Softcore"),
	("gvr", "Spanking", "", "Spanking"),
	("gvr", "Stories", "", "Stories"),
	("gvr", "CelebSuperModel", "", "CelebSuperModel"),
	("gvr", "Swingers", "", "Swingers"),
	("gvr", "TeenGirls", "", "TeenGirls"),
	("gvr", "TeenBoys", "", "TeenBoys"),
	("gvr", "Toys", "", "Toys"),
	("gvr", "Transgender", "", "Transgender"),
	("gvr", "Variety", "", "Variety"),
	("gvr", "Voyeur", "", "Voyeur"),
	("gvr", "Women", "", "Women"),
	("ugs", "1", "", "Misc."),
	("ugs", "2", "", "Asian"),
	("ugs", "3", "", "Ebony"),
	("ugs", "4", "", "Latino"),
	("ugs", "5", "", "Amateur"),
	("ugs", "6", "", "Celebrity"),
	("ugs", "7", "", "Hardcore"),
	("ugs", "8", "", "Fetishes"),
	("ugs", "9", "", "Bizarre"),
	("ugs", "10", "", "Hot"),
	("ugs", "11", "", "Bondage"),
	("ugs", "12", "", "Twinks"),
	("ugs", "13", "", "Bears"),
	("ugs", "14", "", "Hunks"),
	("ugs", "15", "", "Cowboys"),
	("ugs", "16", "", "Leather"),
	("ugs", "17", "", "Uniforms"),
	("ugs", "18", "", "Underwear"),
	("ntv", "0", "", "General"),
	("ntv", "1", "", "Lesbian"),
	("ntv", "2", "", "Asian"),
	("ntv", "3", "", "Straight"),
	("ntv", "4", "", "Gay"),
	("ntv", "5", "", "Oral"),
	("ntv", "7", "", "Amateur"),
	("ntv", "8", "", "Bondage"),
	("ntv", "9", "", "Group Sex"),
	("ntv", "10", "", "Anal"),
	("ntv", "11", "", "Celebs"),
	("ntv", "12", "", "Fetish"),
	("ntv", "13", "", "Paysites"),
	("ntv", "14", "", "Extreme"),
	("ntv", "15", "", "Anime"),
	("ntv", "16", "", "Interracial"),
	("ntv", "17", "", "Studs"),
	("ntv", "18", "", "Babes"),
	("ntv", "19", "", "18 & 19"),
	("ntv", "20", "", "Ebony"),
	("fnp", "26", "", "Amateur"),
	("fnp", "29", "", "Anime"),
	("fnp", "9", "", "Asian Women"),
	("fnp", "23", "", "Barely LegalTeens"),
	("fnp", "27", "", "Bondage"),
	("fnp", "28", "", "Celebrity"),
	("fnp", "14", "", "Ebony"),
	("fnp", "17", "","Ethnic Women"),
	("fnp", "8", "", "Fetish"),
	("fnp", "4", "", "Hardcore"),
	("fnp", "7", "", "Lesbian"),
	("fnp", "18", "", "Models"),
	("fnp", "24", "", "Older Women"),
	("fnp", "12", "", "Oral Sex"),
	("fnp", "5", "", "Softcore"),
	("fnp", "10", "", "Video and Live Stream"),
	("fnp", "16", "", "Voyeur"),
	("fnp", "25", "", "Women"),
	("gmp", "Amateur", "", "Amateur"),
	("gmp", "Black", "", "Black"),
	("gmp", "Bondage", "", "Bondage"),
	("gmp", "Celebrities", "", "Celebrities"),
	("gmp", "Ethnic", "", "Ethnic"),
	("gmp", "Fetishes", "", "Fetishes"),
	("gmp", "Hairy", "", "Hairy"),
	("gmp", "Hardcore", "", "Hardcore"),
	("gmp", "Leather", "", "Leather"),
	("gmp", "Movies", "", "Movies"),
	("gmp", "Other", "", "Other"),
	("gmp", "Stud", "", "Stud"),
	("gmp", "Underwear", "", "Underwear"),
	("gmp", "Uniforms", "", "Uniforms"),
	("gmp", "Young", "", "Young");

create	table	ap_avs_catmap (
	avs		char(3)		not null,
	cat		varchar(10)	not null,
	code_1		varchar(20)	not null,
	value_1		varchar(10),
	code_2		varchar(20),
	value_2		varchar(10),
	code_3		varchar(20),
	value_3		varchar(10)
);

create	table	ap_avs_accounts (
	id		int(3)		not null,
	avs		char(3)		not null,
	acct		varchar(20),
	pass		varchar(20),
	realid		varchar(20),
	cday		date,
	subs		int(2),
	enabled		tinyint(1)	default 1,
	primary key (id)
);



# SE tables
create	table	ap_se (
	id		char(3)		not null,
	name		char(16)	not null,
	enabled		tinyint(1)	not null	default 1,
	
	primary key	(id)
);
insert	into ap_se 	values
	("ggl", "Google", 		1),
	("wcr", "WebCrawler", 		1),
	("lyc", "Lycos", 		1),
	("wys", "What-U-Seek",		1),
	("exc", "Excite", 		1),
	("hbt", "Hotbot", 		1),
	("ntl", "NorthernLight",	1);

create	table	ap_se_fields (
	se		char(3)		not null,
	host		varchar(35)	not null,
	cgi		varchar(30)	not null,
	url		varchar(20)	not null,
	sitename	varchar(12),
	descr		varchar(12),
	name		varchar(12),
	email		varchar(12),
	pass		varchar(12),
	params		varchar(150),
	matchstr	varchar(40)
);

insert	into ap_se_fields values
	("ggl", "www.google.com",		"/addurl",
		"q", "", "dq", "", "", "", "",
		"has been successfully added"),
	("wcr", "www.excite.com",		"/cgi/add_url_new.cgi",
		"url", "", "", "", "", "", "Service=webcrawler&Webcrawler=webcrawler&language=English&country=US&channel=Other&look=webcrawler&email=asdf@asdf.com&submit=Send",
		"info/add_url/thanks"),
	("lyc", "www.lycos.com",		"/cgi-bin/spider_now.pl",
		"query", "", "", "", "email", "", "",
		"successfully spidered"),
	("wys", "add.whatuseek.com",		"/cgi-bin/addurl.cgi",
		"url", "", "", "", "", "", "email=asdf@asdf.com&chk7=156",
		"add-url-return.shtml"),
	("exc", "www.excite.com",		"/cgi/add_url.cgi",
		"url", "", "", "", "email", "", "look=excite",
		"site has been submitted"),
	("hbt", "hotbot.lycos.com",		"/addurl.asp",
		"newurl", "", "", "", "email", "", "",
		"Web site will be added"),
	("ntl", "urls.northernlight.com",	"/cgi-bin/urlsubmit.pl",
		"page", "", "", "contact", "email", "", "",
		"Thank you for your URL submission");
	

create	table	ap_freehosts (
	id		int(3)		auto_increment not null,
	name		varchar(30)	not null,
	host		varchar(30)	not null,
	port		int(5),
	user		varchar(20)	not null,
	pass		varchar(20)	not null,
	rootdir		varchar(40)	not null,
	rooturl		varchar(70)	not null,
	enabled		tinyint(1)	not null,
	primary key (id)
);



# Run timing table
create	table	ap_schedule (
	hr		int(2)		not null,
	runs		int(2)		not null,
	cat		varchar(10),
	mod_1		char(3),
	mod_2		char(3),
	mod_3		char(3),
	mod_4		char(3),
	mod_5		char(3),
	genlinksite	tinyint(1)	not null
);



EOF













# Insert example data into database

if [ $INCLUDE_EXAMPLES = "yes" ]; then
$MYSQL -u $MYSQL_USER -p$MYSQL_PASS -h $MYSQL_HOST -P $MYSQL_PORT $MYSQL_DB <<EOF \
	|| die "Could not create example data"

insert	into ap_cats	values
	("hardcore"),
	("oral"),	
	("fetish"),
	("amateur"),
	("asian"),
	("ebony"),
	("teen"),
	("gay"),
	("lesbian"),
	("anal");

# Example site names
insert	into ap_sitenames values
	("Absolute Anal",	"anal"),
	("Adorable Teens",	"teen"),
	("All XXX Hardcore", 	"hardcore"),
	("Amateurs Galore", 	"amateur"),
	("Asian XXX", 		"asian"),
	("Ass Masters",		"anal"),
	("Black Heaven",	"ebony"),
	("Blowjob Sluts",	"oral"),
	("Cheerleader Sex",	"teen"),
	("Cum Drinking",	"oral"),
	("Cunt Busters",	"teen"),
	("Dildo Girls",		"hardcore"),
	("Dungeon XXX",		"fetish"),
	("Ebony Island",	"ebony"),
	("Free Fetish",		"fetish"),
	("Free Hunks",		"gay"),
	("Free Sexxx",		"hardcore"),
	("Hardcore Heaven",	"hardcore"),
	("Hardcore XXX",	"hardcore"),
	("Hot Young Girls",	"teen"),
	("Interracial Love",	"ebony"),
	("Just 17",		"teen"),
	("Lesbian Dungeon",	"lesbian"),
	("Lesbian Pussy",	"lesbian"),
	("Luscious Lesbos",	"lesbian"),
	("Nude Guys",		"gay"),
	("Odd Orifices",	"fetish"),
	("Porn Porn Porn",	"teen"),
	("REAL SEX!",		"amateur"),
	("Sex Pix",		"teen"),
	("Sexy Boys",		"gay"),
	("SickSex",		"fetish"),
	("Taboo Erotica",	"fetish"),
	("Teen Angels",		"teen"),
	("Teen Cuties",		"teen"),
	("Ultimate Gays",	"gay"),
	("Wet And Waiting",	"lesbian"),
	("X-Treme Hardcore!",	"hardcore"),
	("XXXTreme Sickness",	"fetish"),
	("Young Lovers",	"teen");

insert	into ap_headers	values
	("Barely Legal European Girls",			"teen"),
	("Hot young sluts doing it all for you!",	"teen hardcore"),
	("Huge selection of top-quality pix",		""),
	("Hundreds of hardcore black pictures",		"hardcore"),
	("Meet our lesbian lovers!",			"lesbian"),
	("You'll never see anything this sick again",	"fetish"),
	("No holds barred in this sick orgy",		"hardcore fetish"),
	("Pictures of all our amateurs",		"amateur"),
	("The hottest guys you'll ever see",		"gay"),
	("Virgins losing their cherries for YOU",	"teen");

insert	into ap_descr	values
	("Hundreds of top-quality XXX pictures, plus an unbeatable selection of stories, movies and LIVE FEEDS!", ""),
	("The hottest legal pics you'll ever see! You've GOT to check this out!", ""),
	("Described as 'one of the best adult sites on the web', this really is one you can't miss", ""),
	("Young hunks giving each other all they've got and loving it!!", "gay");

insert	into ap_paragraphs values
	("Take a walk on the wild side.  The wildest, raunchiest naked babes on the net are wet and willing and waiting for you right here.  Cum on in and join the fun!", "lesbian teen hardcore"),
	("Step inside and let us make your wildest dreams come true.  We've got it all...no kink too kinky, no perversion too perverted.  What you want...we've got!", ""),
	("Blondes, brunettes, redheads, bald girls (?!)...  No matter where your taste lies, we've got em all right here, for you to...taste. ;)", "oral teen"),
	("We need spanked sooo bad. We've been bad. Come in and punish us..", "fetish"),
	("I didn't want to take these pictures but he Forced me to .. and he did... things.. to me..", "fetish"),
	("Take me fast...take me slow...take me high...take me low...take me any way you want.  I just can't get enough!", "hardcore"),
	("He watched her through the closet door slowly, teasingly removing her clothes. Til he had to put the camera down and get personally involved. Come see the pictures.", ""),
	("Sarah and her friend were just taking a late night swim when Sarah lost her top. See the pictures of what happened next!", "lesbian teen"),
	("Weird shit... we've got the lot ... women and dogs ... women and horses ... women and dogs and horses ... nothing is too sick for us.", "fetish"),
	("Sexy teen boys having their first sexual adventures - rimming, enemas, and a whole lot more!", "gay");

insert	into ap_keywords values
	("adult", 	""),
	("amateur", 	"amateur"),
	("anal",	"anal"),
	("asian",	"asian"),
	("ass",		"anal hardcore"),
	("babes",	"teen"),
	("bang",	"hardcore anal"),
	("bath",	"lesbian"),
	("beaver",	"teen"),
	("bj",		"oral"),
	("blowjob",	"oral hardcore"),
	("butt",	"anal fetish"),
	("cheerleader",	"teen lesbian"),
	("closeups",	"hardcore"),
	("cock",	"hardcore gay"),
	("coeds",	"teen"),
	("cumshots",	"hardcore"),
	("delicious",	"teen lesbian"),
	("dildo",	"hardcore"),
	("ebony",	"ebony"),
	("eighteen",	"teen"),
	("erotic",	"hardcore teen"),
	("extreme",	"fetish"),
	("fetish",	"fetish"),
	("fucking",	"hardcore gay teen lesbian"),
	("galleries",	"teen hardcore gay"),
	("hardcore",	"hardcore lesbian"),
	("interracial",	"ebony asian"),
	("lesbian",	"lesbian teen"),
	("lesbians",	"lesbian"),
	("lusty",	"teen lesbian gay"),
	("nasty",	"fetish"),
	("nympho",	"teen lesbian"),
	("pictures",	""),
	("porn",	""),
	("pussy",	"lesbian teen hardcore"),
	("schoolgirls",	"teen lesbian"),
	("sex",		""),
	("shaved",	"lesbian fetish"),
	("sorority",	"teen"),
	("teenage",	"teen"),
	("uncensored",	""),
	("virgins",	"teen lesbian"),
	("whores",	"anal");

insert	into ap_pagetypes values
	("intro"),
	("taster"),
	("enter"),
	("content");

insert	into ap_layouts	values
	("default", "", "", 1, "",
	"intro", "enter", "", "", "", "",
	"content", "", "", "", "", "", "", "", "", "",
	"", "", "", "", "");

insert	into ap_dirs	values
	("lusty", 	""),
	("hardcore", 	"hardcore"),
	("eighteen", 	"teen"),
	("ass", 	"anal"),
	("wicked",	"fetish"),
	("girl",	"teen lesbian"),
	("shaved",	"teen hardcore");

insert	into ap_direxts values
	("123"),
	("xxx"),
	("sex"),
	("paradise"),
	("101"),
	("2k");

insert	into ap_memarea	values
	("xxxmembers"),
	("membersxxx"),
	("memberz"),
	("hotstuff"),
	("members_area"),
	("mem_area"),
	("validated"),
	("members_xxx"),
	("memarea"),
	("MEM");

insert	into ap_htmlext	values
	("html"),
	("html"),
	("htm"),
	("shtml");

insert	into ap_sponsors values
	("amateurfree",	"Amateur Freedom",	"amateur",		"http://www.adultrevenueservice.com/re.php?s=AF&a=101066"),
	("amateuruni",	"Amateur University",	"amateur",		"http://www.adultrevenueservice.com/re.php?s=AU&a=101066"),
	("analpassion",	"Anal Passions",	"anal hardcore",	"http://www.adultrevenueservice.com/re.php?s=AP&a=101066"),
	("asianexxx",	"Asian Exxxtasy",	"asian",		"http://www.adultrevenueservice.com/re.php?s=AE&a=101066"),
	("bearlove",	"Bear Lovin",		"gay",			"http://www.adultrevenueservice.com/re.php?s=BL&a=101066"),
	("blackdes",	"Black Desires",	"ebony",		"http://www.adultrevenueservice.com/re.php?s=BL&a=101066"),
	("breathless",	"Breathless Boys",	"gay",			"http://www.adultrevenueservice.com/re.php?s=BB&a=101066"),
	("boytoy",	"Boy Toy Live",		"gay",			"http://www.adultrevenueservice.com/re.php?s=BTL&a=101066"),
	("chixwithdix",	"Chix With Dix",	"fetish",		"http://www.adultrevenueservice.com/re.php?s=CWD&a=101066"),
	("cutegf",	"Cute Girlfriend",	"teen",			"http://www.adultrevenueservice.com/re.php?s=CG&a=101066"),
	("darkobsess", 	"Dark Obsessions",	"fetish",		"http://www.adultrevenueservice.com/re.php?s=DO&a=101066"),
	("femdom", 	"Fem Domination",	"fetish",		"http://www.adultrevenueservice.com/re.php?s=FD&a=101066"),
	("gayultra", 	"Gay Ultra",		"gay",			"http://www.adultrevenueservice.com/re.php?s=ULT&a=101066"),
	("golden", 	"Golden Trickle",	"fetish",		"http://www.adultrevenueservice.com/re.php?s=GT&a=101066"),
	("interracial",	"Hard Interracial",	"asian ebony hardcore",	"http://www.adultrevenueservice.com/re.php?s=HI&a=101066"),
	("harddigital",	"Hardcore Digital",	"hardcore",		"http://www.adultrevenueservice.com/re.php?s=HD&a=101066"),
	("legsnfeet", 	"Legs N Feet",		"fetish",		"http://www.adultrevenueservice.com/re.php?s=LF&a=101066"),
	("lesbord",	"Lesbian Bordello",	"lesbian",		"http://www.adultrevenueservice.com/re.php?s=BOR&a=101066"),
	("lickinlovers", "Lickin' Lovers",	"oral lesbian",		"http://www.adultrevenueservice.com/re.php?s=LL&a=101066"), 
	("orallovers",	"Oral Lovers",		"oral",			"http://www.adultrevenueservice.com/re.php?s=OL&a=101066"),
	("pinkchoc", 	"Pink Chocolate",	"ebony",		"http://www.adultrevenueservice.com/re.php?s=PC&a=101066"),
	("pussyquota", 	"Pussy Quota",		"teen hardcore",	"http://www.adultrevenueservice.com/re.php?s=PQ&a=101066"),
	("sinfulhc", 	"Sinful Hardcore",	"hardcore",		"http://www.adultrevenueservice.com/re.php?s=SH&a=101066"),
	("teendreamer", "Teen Dreamer",		"teen",			"http://www.adultrevenueservice.com/re.php?s=TD&a=101066");

insert	into ap_textlinks values
	("In-your-face fucking like you've never seen it before!", "", 	"hardcore"),
	("The real thing, close up!", "",				"hardcore"),
	("Hardcore XXX Action",	"",					"hardcore"),
	("Delicious licking and sucking", "",				"oral"),
	("Choose your poison", "",					"fetish"),
	("This stuff is SICK", "",					"fetish"),
	("Feet galore", "",						"fetish"),
	("Is your neighbour, best friend or even wife here?", "",	"amateur"),
	("Gorgeous Asian girls", "",					"asian"),
	("Black booty babes shaking their thing and dying to party", "", "ebony"),
	("Girls in their prime", "",					"teen"),
	("Young, innocent beauties, awaiting a REAL man", "",		"teen"),
	("This isn't gentle. This is serious, in your face cock sucking action.", "", "gay"),
	("Gorgeous hunks bending over for you", "",			"gay"),
	("More tight wet twats than you can lick in a year!", "", 	"hardcore"),
	("Countless hot girls, fingering each other until they're dry", "", "lesbian"),
	("She wants it up the dirt track!", "",				"anal");

insert	into ap_schemes	values
	("light", 	""),
	("innocence",	"teen lesbian"),
	("dungeon",	"fetish hardcore");

insert	into ap_bodytags values
	("bgcolor=#eeeeff text=#000000 link=#ff0000", 	"light"),
	("bgcolor=#ffffff text=#ff0000 link=#0000ff",	"light"),
	("bgcolor=#ccffcc text=#000000 link=#0000ff",	"light"),
	("bgcolor=#ffaaff text=#ff0000 link=#550000",	"innocence"),
	("bgcolor=#ffffaa text=#222288 link=#000088",	"innocence"),
	("bgcolor=#000000 text=#ee0000 link=#ff4444",	"dungeon");

insert	into ap_tabletags values
	("cellpadding=5 cellspacing=5",			"light"),
	("cellpadding=4 cellspacing=7 border=1", 	"innocence"),
	("cellpadding=4 cellspacing=4",			"dungeon");

insert	into ap_tdtags	values
	("bgcolor=#ddddee text=#000000 link=#ff0000",	"light"),
	("bgcolor=#eeeeff text=#ff0000 link=#0000ff",	"light"),
	("bgcolor=#bbffbb text=#000000 link=#0000ff",	"light"),
	("bgcolor=#ffccff text=#ff0000 link=#550000",	"innocence"),
	("bgcolor=#eeeebb text=#222288 link=#000088",	"innocence"),
	("bgcolor=#442222 text=#ee9999 link=#ff0000",	"dungeon");

insert	into ap_fonttags values
	("face='Verdana, Arial, sans-serif' size=2", 	"light"),
	("face='Tahoma, Arial, sans-serif' size=1",	"light"),
	("face='Times, Geneva, serif' size=2",		"innocence"),
	("face='Arial, sans-serif' size=2",		"dungeon"),
	("face='Verdana, Tahoma, sans-serif' size=2",	"dungeon");

insert	into ap_custtag1 values
	("i", "light"),
	("b", "light"),
	("u", "light");


insert	into ap_avs_accounts values
	(1, "cyb", "4117000", "", "", "", "", "1");
EOF
fi

$PERL -i -pe "s/%mysqluser%/$MYSQL_USER/g; s|%mysqlpass%|$MYSQL_PASS|g; \
	s/%mysqlhost%/$MYSQL_HOST/g; s/%mysqlport%/$MYSQL_PORT/g; \
	s/%mysqldb%/$MYSQL_DB/g; s/%dirperms%/0777/; s!%tmppath%!$TMPPATH!" routines.pl

echo Script run completed, all data should be present
